﻿// utils.js - Funzioni di utilità

function generateUniqueCode() {
    return 'SALE-' + Date.now(); // Esempio semplice, puoi personalizzarlo ulteriormente
}
function showSuccess(message) {
    Swal.fire({
        icon: 'success',
        title: 'Successo',
        text: message,
        confirmButtonText: 'Ok',
        customClass: { popup: 'my-popup-class' },
        timer: 5000
    });
    $('#pleaseWaitDiv').modal('hide');
}

// Funzione per mostrare messaggi di errore
function showErrorMessage(message) {
    Swal.fire({
        icon: 'warning',
        title: 'Oops...',
        text: message,
        confirmButtonText: 'Ok',
        customClass: { popup: 'my-popup-class' },
        timer: 5000
    });
    $('#pleaseWaitDiv').modal('hide');
}

function handleSuccess(response) {
    console.log("Risposta ricevuta con successo:", response);

    // Mostra un messaggio di successo all'utente
    showSuccess('Vendita completata con successo!');

    // Pulisce il carrello dopo una vendita riuscita
    clearCart();

    // Esegui eventuali altre azioni in base alla risposta ricevuta
    if (response && response.data) {
        // Esempio: aggiorna un log, salva dati aggiuntivi, ecc.
        console.log("Dati specifici della risposta:", response.data);
    }

    // Nasconde overlay e altri elementi di caricamento, se presenti
    document.getElementById('overlay').style.display = 'none';
    $('#pleaseWaitDiv').modal('hide');
}
// Funzione per salvare il carrello nel Local Storage
function saveCartToLocalStorage() {
    const cartItems = [];
    document.querySelectorAll('.cart-item').forEach(item => {
        const prodid = item.getAttribute('data-id');
        const descr = item.querySelector('.descr').textContent.trim();
        const price = parseFloat(item.querySelector('.price').value).toString();
        const qty = parseInt(item.querySelector('.quantity').value).toString();
        const discount = parseFloat(item.querySelector('.discount').value).toString() || "0";
        const vatrep = item.getAttribute('data-vatrep');

        cartItems.push({
            prodid,
            descr,
            price,
            qty,
            discount, 
            vatrep
        });
    });

    // Salva i prodotti del carrello nel Local Storage
    localStorage.setItem('cartItems', JSON.stringify(cartItems));
}
function applyDiscountFromModal() {
    const discountInput = document.getElementById('discountInput');
    const discountValue = parseFloat(discountInput.value);

    if (!isNaN(discountValue) && discountValue >= 0 && discountValue <= 100) {
        // Applica lo sconto a tutti gli articoli
        applyDiscountToAllItems(discountValue);
        // Chiudi il modal
        $('#discountModal').modal('hide');
    } else {
        alert("Per favore, inserisci una percentuale di sconto valida tra 0 e 100.");
    }
}

function applyDiscount() {
    const discountPercentage = prompt("Inserisci la percentuale di sconto da applicare a tutti gli articoli:", "0");
    if (discountPercentage !== null) {
        const discountValue = parseFloat(discountPercentage);
        if (!isNaN(discountValue) && discountValue >= 0 && discountValue <= 100) {
            // Applica lo sconto a tutti gli articoli nel carrello
            applyDiscountToAllItems(discountValue);
        } else {
            alert("Per favore, inserisci una percentuale di sconto valida tra 0 e 100.");
        }
    }
}

function applyDiscountToAllItems(discountValue) {
    const cartItems = document.querySelectorAll('.cart-item');
    cartItems.forEach(item => {
        const discountInput = item.querySelector('.discount');
        if (discountInput) {
            discountInput.value = discountValue;
            // Trigger l'evento 'change' per aggiornare il calcolo del totale
            discountInput.dispatchEvent(new Event('change'));
        }
    });
    // Aggiorna il totale complessivo
    updateOverallTotal();
    // Salva il carrello nel Local Storage (se utilizzi questa funzionalità)
    saveCartToLocalStorage();
}



//function loadCartFromLocalStorage() {
//    const cartData = localStorage.getItem('cartItems');
//    if (cartData) {
//        const cartItems = JSON.parse(cartData);
//        cartItems.forEach(function (item) {
//            addProductToCartFromLocalStorage(item);
//        });
//        updateOverallTotal();
//    }
//}

function loadCartFromLocalStorageOld1() {
    const savedCart = JSON.parse(localStorage.getItem('cart'));
    if (savedCart) {
        savedCart.forEach(function (item) {
            // Verifica che l'item contenga effettivamente prodid prima di chiamare la funzione
            if (item.prodid) {
                addProductToCartFromLocalStorage(item);
            } else {
                console.error("Elemento nel localStorage senza ID prodotto:", item);
            }
        });
    }
}

function loadCartFromLocalStorage() {
    const cartItems = JSON.parse(localStorage.getItem('cartItems')) || []; // Recupera l'array di oggetti
    cartItems.forEach(item => {
        // Aggiungi il prodotto al carrello usando i dati caricati
        addProductToCart(item.prodid, item.descr, item.price, item.vatrep); // Aggiungi il prodotto

        // Imposta anche quantità e sconto
        const cartItem = document.querySelector(`div[data-id="${item.prodid}"]`);
        if (cartItem) {
            cartItem.querySelector('.quantity').value = item.qty; // Imposta la quantità
            cartItem.querySelector('.discount').value = item.discount; // Imposta lo sconto
            updateTotalPrice(cartItem); // Aggiorna il prezzo totale
        }
    });
}

// Carica il carrello dal localStorage quando la pagina viene caricata
document.addEventListener('DOMContentLoaded', loadCartFromLocalStorage);


// Funzione per ottenere la data corrente in diversi formati
function getCurrentDate(format = 1) {
    const now = new Date();
    const day = String(now.getDate()).padStart(2, '0');
    const month = String(now.getMonth() + 1).padStart(2, '0');
    const year = now.getFullYear();
    const hours = String(now.getHours()).padStart(2, '0');
    const minutes = String(now.getMinutes()).padStart(2, '0');
    const seconds = String(now.getSeconds()).padStart(2, '0');

    if (format === 1) {
        // Formato yyyy-mm-dd HH:MM:SS
        return `${year}-${month}-${day}T${hours}:${minutes}:${seconds}`;
    } else {
        // Formato dd/mm/yyyy HH:MM:SS
        return `${day}-${month}-${year}`;
    }
}

// Funzione generica per mostrare messaggi
function showMessage(type, title, message) {
    Swal.fire({
        icon: type,
        title: title,
        text: message,
        confirmButtonText: 'Ok',
        customClass: { popup: 'my-popup-class' },
        timer: 5000
    });
    $('#pleaseWaitDiv').modal('hide');
}

// Esempi di utilizzo:
// showMessage('success', 'Successo', 'Operazione completata con successo');
// showMessage('warning', 'Attenzione', 'Si è verificato un errore');
