﻿// events.js - Funzioni per la gestione degli eventi del documento

// Funzione per eseguire la ricerca
function executeSearch() {
    const searchValue = document.getElementById('barcodeInput').value.trim();
    if (searchValue) {
        console.log('Esegui la ricerca per:', searchValue);
        searchProduct(searchValue);
    }
}

// Funzione per processare il barcode
function processBarcode2(barcode) {
    if (barcode.trim() !== '') {
        SellMe(barcode);
    } else {
        console.warn('Barcode vuoto ignorato.');
    }
}

// Funzione per processare il barcode
function processBarcode(barcode) {
    // Rimuove l'asterisco iniziale se presente
    if (barcode.startsWith('*')) {
        barcode = barcode.slice(1);
    }
    if (barcode.trim() !== '') {
        console.log("Prodotto letto dal barcode:", barcode);
        // Aggiungi qui la logica per cercare e gestire il prodotto
        if (barcode.trim() !== '') {
            SellMe(barcode);
        } else {
            console.warn('Barcode vuoto ignorato.');
        }
        //addProductToCart(barcode);
    } else {
        console.warn('Barcode vuoto ignorato.');
    }
}

function sendCommandToCashRegister(command) {
    console.log('Comando inviato alla cassa:', command);

    // Qui aggiungi la logica per inviare il comando alla cassa
    // Può essere un'API, un'interfaccia o altro
    $.ajax({
        url: '/sendCommandToCashRegister',
        type: 'POST',
        data: { command: command },
        success: function (response) {
            console.log('Risposta dalla cassa:', response);
            showMessage('success', 'Comando inviato', 'Il comando è stato eseguito correttamente.');
        },
        error: function (error) {
            console.error('Errore durante l\'invio del comando:', error);
            showMessage('error', 'Errore', 'Non è stato possibile eseguire il comando.');
        }
    });
}
function performCashClose() {
    // Richiama l'API o il metodo per cancellare i file SCO*.* prima della chiusura
    $.ajax({
        url: '/cleanSCOFiles', // Chiamata ad un endpoint che esegue la pulizia
        type: 'POST',
        success: function (response) {
            // Continua con la chiusura della cassa se l'eliminazione dei file è andata a buon fine
            CashClose();
        },
        error: function (error) {
            console.error('Errore durante la pulizia dei file SCO*.*: ', error);
        }
    });
}
function resetCash() {
    // REP FIN
    commands = [];
    commands.push("CLEAR");
    commands.push("RESPRN");
    send2localproxy(commands);
}
function lastReceipt() {
    // Ristampa ultimo scontrino - copia non fiscale
    $.ajax({
        url: '/api/proxy/reprintlast',
        type: 'POST',
        contentType: 'application/json',
        success: function(response) {
            console.log('Ristampa avviata con successo');
            Swal.fire({
                icon: 'success',
                title: 'Ristampa',
                text: 'Ristampa ultimo scontrino in corso...',
                timer: 2000,
                showConfirmButton: false
            });
        },
        error: function(xhr, status, error) {
            console.error('Errore ristampa:', error);
            Swal.fire({
                icon: 'error',
                title: 'Errore',
                text: 'Errore durante la ristampa: ' + (xhr.responseJSON?.message || error)
            });
        }
    });
}

// inp term=37
function openDraw() {
    // REP FIN
    commands = [];
    commands.push("INP TERM=37");
    send2localproxy(commands);
}
function CashClose() {
    //var cmd = [];
    //document.getElementById("cashclose").disabled = true;
    $('html,body').css('cursor', 'wait');
    //$("#cashclose").attr("disabled", "disabled").off('click');
    // console.log(sendInfo);
    document.getElementById('overlay').style.display = 'flex';
        commands = [];
        commands.push("CLEAR");
        commands.push("RESPRN");
        commands.push("AZZGIO TIPO=1");
        commands.push("RTEJ INVIOAE");
        send2localproxy(commands);
 
}

// Apri la modale di conferma
function showCloseConfirmation() {
    $('#confirmCloseModal').modal('show');
}

// Quando l'utente conferma la chiusura
document.getElementById('confirmCloseBtn').addEventListener('click', function () {
    $('#confirmCloseModal').modal('hide');
    performCashClose();
});
document.addEventListener('DOMContentLoaded', function () {
    // Inizializzazione del documento con cattura barcode e input manuale
    const searchInput = document.getElementById('barcodeInput');
    loadCartFromLocalStorage();

    // Auto-select all text when cart input fields receive focus
    $(document).on('focus', '.cart-item input[type="text"], .cart-item input[type="number"]', function() {
        const input = this;
        // Small delay to ensure the value is set before selecting
        setTimeout(function() {
            input.select();
        }, 10);
    });

    // Return focus to barcode input after editing cart fields
    $(document).on('blur', '.cart-item input', function() {
        // Small delay to allow click events on other elements to fire first
        setTimeout(function() {
            // Only refocus if no modal is open and no dropdown is visible
            if (!$('.modal.show').length && !$('#searchResults').is(':visible')) {
                $('#barcodeInput').focus();
            }
        }, 100);
    });

    $('#printReceipt').on('click', function (event) {
        event.preventDefault();
        lastReceipt();
        //sendCommandToCashRegister('stampa_ricevuta');
    });

    // Evento per l'apertura del cassetto
    $('#openCashDrawer').on('click', function (event) {
        event.preventDefault();
        openDraw();
    });

    // Evento per il report giornaliero (chiusura) - mostra conferma
    $('#dailyReport').on('click', function (event) {
        event.preventDefault();
        $('#confirmCloseModal').modal('show');
    });

    // Evento per il reset della cassa - mostra conferma
    $('#resetCashRegister').on('click', function (event) {
        event.preventDefault();
        $('#confirmResetModal').modal('show');
    });

    // Quando l'utente conferma il reset
    $('#confirmResetBtn').on('click', function () {
        $('#confirmResetModal').modal('hide');
        resetCash();
    });

    if (searchInput) {
        // Evita che Invio nell'input faccia il submit e gestisci la ricerca
        searchInput.addEventListener('keydown', function (event) {
            if (event.key === 'Enter') {
                event.preventDefault(); // Previene il submit del form
                executeSearch(); // Esegui la funzione di ricerca
            }
        });

        // Esegui la ricerca quando l'input perde il focus
        searchInput.addEventListener('blur', function (event) {
            if (!event.relatedTarget || !event.relatedTarget.classList.contains('dropdown-item')) {
                executeSearch();
            }
        });
    }

    // Previeni il submit del form su qualsiasi Enter
    document.querySelectorAll('form').forEach(form => {
        form.addEventListener('submit', function (event) {
            event.preventDefault(); // Previene il comportamento di submit di default
            console.log('Submit prevenuto per il form:', form.id);
        });
    });

    // Inizializzazione della data corrente
    const currentDate = new Date().toISOString().slice(0, 10);
    $('#SellDate').val(currentDate);

    // Variabili per la gestione del barcode
    let barcode = '';
    let barcodeTimeout;

    // Gestione della cattura del barcode, senza il focus su un elemento input
    $(document).keypress(function (event) {
        // Controlla se il focus è su un elemento input o textarea
        if (!$(event.target).is('input, textarea')) {
            // Solo se il focus non è su un input, catturiamo il barcode
            event.preventDefault();

            if (event.key.length === 1) {
                barcode += event.key;
                clearTimeout(barcodeTimeout);
                barcodeTimeout = setTimeout(function () {
                    processBarcode(barcode);  // Processa il barcode dopo il timeout
                    barcode = '';  // Resetta il barcode
                }, 500);  // Timeout per considerare che la scansione è completata
            } else if (event.key === 'Enter' && barcode !== '') {
                processBarcode(barcode);  // Processa il barcode al tasto "Enter"
                barcode = '';  // Resetta il barcode
            }
        }
    });
});
