﻿// ajax.js - Funzioni per effettuare le chiamate AJAX

function showError(message) {
    Swal.fire({
        icon: 'error',
        title: 'Errore',
        text: message
    });
}
function SellMe(barcode) {
    console.log("Esegui ricerca prodotto con barcode:", barcode);
    $.ajax({
        url: '/GetProductsByBarcode',
        type: 'GET',
        data: { barcode: barcode },
        success: function (data) {
            console.log('Dati ricevuti:', data);

            // Controlla se i dati ricevuti sono un array e contengono elementi
            if (data && Array.isArray(data) && data.length > 0) {
                var product = data[0]; // Prendi il primo prodotto dalla lista
                var descr = product.description;
                var prodid = product.product_ID; // Assicurati di usare product_ID
                var prices = parseFloat(product.sellPrice).toFixed(2);
                var vatrep = product.vatRep;

                // Verifica che l'ID prodotto sia valido
                if (!prodid) {
                    console.error("ID prodotto non trovato:", product);
                    showMessage('info', 'Errore', 'Errore durante la ricerca del prodotto.');
                    return;
                }

                console.log("Dati elaborati", descr, prodid, prices, vatrep);

                // Aggiungi il prodotto al carrello
                //addProductToCart(prodid, descr, prices, vatrep);

                // Controllo se è un articolo generico (qta < 0)
                if (product.quantity < 0) {
                    // Articolo generico: genera un ID univoco con timestamp
                    const Product_ID = `${prodid}-${Date.now()}`;
                    addProductToCart(Product_ID, descr, prices, vatrep);
                } else {
                    // Articolo normale: usa l'ID del prodotto così com'è
                    addProductToCart(prodid, descr, prices, vatrep);
                }

            } else if (data && data.success === false) {
                showMessage('warning', 'Attenzione', data.message || 'Prodotto non trovato!');
            } else {
                showMessage('info', 'Errore', 'Prodotto non trovato!');
            }
        },
        error: function (error) {
            console.error('Errore durante la ricerca del prodotto:', error);
            showMessage('error', 'Errore', 'Errore durante la ricerca del prodotto.');
        }
    });
}


// Funzione per costruire i comandi basati sul tipo di cassa
function buildCommands(data, paymode) {
    commands = [];
    var items = $('#TableRawMaterial > tbody:last > tr').length - 1;
    var elements = $(".price");
    var vats = $(".qty");
    var descr = $(".descr");
    var vatrep = $(".vatrep");

    if (cashPointsType === 'DITRON') {
        commands.push("cmd=CHIAVE+REG&async=false");
        commands.push("cmd=NOFIS+APRI&async=false");
    } else if (cashPointsType === 'DITRON-RT' || cashPointsType === 'LOCALPROXY') {
        commands.push("CHIAVE REG");
    } else {
        cmd.push("7/1/20//");
    }
    console.log("Data ricevuta:", data);

    // Itera sugli elementi del carrello e costruisce i comandi VEND
    data.Raws.forEach((raw, index) => {
        let description = data.Descr[index].replace("'", " ").replace("\""," ").substring(0, 19);
        let price = parseFloat(data.RawsPrice[index]).toFixed(2); // Prezzo del prodotto
        let quantity = parseFloat(data.RawsQty[index]); // Quantità del prodotto
        let vat = data.RawsVat[index];
        let discount = parseFloat(data.RawsDiscount[index]) || 0; // Sconto per riga
        // Calcola il prezzo scontato
        let discountedPrice = (price * (1 - discount / 100)).toFixed(2);

        // Crea il comando VEND in base al tipo di cassa, includendo lo sconto per riga
        if (cashPointsType === 'DITRON') {
            commands.push(`cmd=VEND+REP%3D${vat}%2C+PRE%3D${discountedPrice}%2C+QTY%3D${quantity}%2C+DES%3D'${description}'&async=false`);
        } else if (cashPointsType === 'DITRON-RT' || cashPointsType === 'LOCALPROXY') {
            commands.push(`VEND REP=${vat}, PRE=${discountedPrice}, QTY=${quantity}, DES='${description}'`);
        } else {
            cmd.push(`3/S/${description.substr(0, 29)}/${quantity}/${discountedPrice}/${vat}/22/`);
        }
    });


    // Aggiungi gli sconti se presenti
    if ($('#PercentDiscount').val() > 0) {
        if (cashPointsType === 'DITRON') {
            commands.push(`cmd=SCONTO+TOT%3D${$('#PercentDiscount').val()}&async=false`);
        } else if (cashPointsType === 'DITRON-RT' || cashPointsType === 'LOCALPROXY') {
            commands.push(`PERCA SUBTOT, ALIQ=${$('#PercentDiscount').val()}`);
        } else {
            cmd.push(`7/1/5/Sconto/${$('#PercentDiscount').val()}%/`);
        }
    }

    // Gestione delle modalità di pagamento
    console.log("Elaborazione del pagamento tipo ", paymode);
    switch (paymode) {
        case "Contanti":
            $('#modalita').html("&nbsp;CONTANTI");
            if (cashPointsType === 'DITRON') {
                commands.push("cmd=CHIUS+T%3D1&async=false");
            } else if (cashPointsType === 'DITRON-RT' || cashPointsType === 'LOCALPROXY') {
                const totalAmount = parseFloat($('#total-amount').text().replace('€', '').trim());
                const receivedAmount = parseFloat($('#receivedAmount').val()) || 0; // Recupera l'importo ricevuto
                let closingCommand = '';
                if (receivedAmount > totalAmount) { // Controlla se c'è resto
                    commands.push(`CHIUS T=1, IMP=${receivedAmount.toFixed(2)}`);
                } else {
                    commands.push("CHIUS T=1");
                }
            } else {
                cmd.push("5/1/0////PC/");
            }
            break;
        case "Elettronico":
            $('#modalita').html("&nbsp;CREDITO");
            if (cashPointsType === 'DITRON') {
                commands.push("cmd=CHIUS+T%3D5&async=false");
            } else if (cashPointsType === 'DITRON-RT' || cashPointsType === 'LOCALPROXY') {
                commands.push("CHIUS T=5");
            } else {
                cmd.push("5/5/0////PE/");
            }
            break;
        case 2:
            $('#modalita').html("&nbsp;BANCOMAT");
            if (cashPointsType === 'DITRON') {
                commands.push("cmd=INP+TERM%3D125&async=false");
            } else if (cashPointsType === 'DITRON-RT' || cashPointsType === 'LOCALPROXY') {
                commands.push("CHIUS T=2");
            } else {
                cmd.push("5/2/0////");
            }
            break;
        default:
            showError("Metodo di pagamento non riconosciuto.");
            break;
    }

    console.log("Comandi creati:", commands);
}

// Funzione per eseguire i comandi basati sul tipo di cassa
function executeCommands(data, paymode) {
    if (cashPointsType === 'DITRON') {
        send2Ditron();
    } else if (cashPointsType === 'DITRON-RT') {
        send2Ditron2();
    } else if (cashPointsType === 'LOCALPROXY') {
        send2localproxy(data);
    } else {
        SendToLocalServer();
    }
}

// Funzioni di invio specifiche (assicurati che queste funzioni siano definite correttamente nel contesto)
function send2Ditron() {
    // Logica per inviare i comandi al registratore di cassa Ditron
    console.log("Invio comandi a Ditron");
    // Implementazione specifica per il registratore Ditron
}

function send2Ditron2() {
    // Logica per inviare i comandi al registratore di cassa Ditron-RT
    console.log("Invio comandi a Ditron-RT");
    // Implementazione specifica per il registratore Ditron-RT
}

async function send2localproxy(data) {
    console.log('Invio al proxy locale, index: ' + index);
    restCmd = "";
    var ix;

    for (ix = 0; ix < commands.length; ix++) {
        restCmd += commands[ix] + "\r\n";
        console.log("Comando elaborato: " + ix + " -> " + commands[ix]);
    }
    restCmd += "wecfine\r\n";

    var saleData = $("#Sale").serialize();
    if (data && data.id) {
        saleData += '&saleid=' + data.id;
    }

    console.log('Comandi inviati: ' + restCmd + ' | Dati vendita: ' + saleData);

    makeAjaxCallCombine(cashPoints, restCmd, saleData)
        .then(function (response) {
            handleSuccess(response);
            console.log('Risposta ricevuta -> ' + restCmd + ' ' + response);
            restCmd = "";
            cmd.length = 0;
        })
        .catch(function (error) {
            console.error('Errore durante la chiamata al proxy:', error);
            restCmd = "";
            cmd.length = 0;

            $(".success").show();
            $(".failureText").show();
            if (error && error.message && error.message.includes('net::ERR_CONNECTION_REFUSED')) {
                console.log('Errore di connessione rifiutata');
                $(".errorMessage").html('Errore di connessione al registratore di cassa: Controllare CashProxy');
            } else {
                $(".errorMessage").html('Attenzione ERRORE comunicazione con registratore di cassa!!!!');
            }

            document.getElementById('overlay').style.display = 'none';
            $('#pleaseWaitDiv').modal('hide');
            setTimeout(function () {
                $(".success").hide();
                $(".failureText").hide();
            }, 7000);
        });
}

function SendToLocalServer() {
    // Logica per inviare i comandi al server locale
    console.log("Invio comandi al server locale");
    // Implementazione specifica per l'invio al server locale
}

// Funzione per gestire una vendita completata con successo
function handleSuccessfulSale(data, paymode) {
    console.log("Vendita completata con successo:", data);
    removeLoadingOverlay();
    // Mostra un messaggio di successo all'utente
    showSuccess('Vendita completata con successo!');

    // Pulisce il carrello dopo una vendita riuscita
    clearCart();
    localStorage.removeItem('cartItems'); // Rimuove il carrello dal localStorage

    // Esegui eventuali altre azioni basate sui dati della vendita e modalità di pagamento
    if (data && data.Raws && data.Raws.length > 0) {
        console.log("Dettagli della vendita:", data);
        // devo recuperare il numero dello scontrino 
    }

    // Nascondi overlay o modali di caricamento se presenti
    document.getElementById('overlay').style.display = 'none';
    $('#pleaseWaitDiv').modal('hide');
}

function searchProduct(searchValue) {
    console.log('Esegui ricerca prodotto:', searchValue);
    $.ajax({
        url: '/search',
        method: 'GET',
        data: { txtsearch: searchValue },
        success: function (data) {
            console.log('Dati ricevuti:', data);
            if (data.success === false) {
                showMessage('warning', 'Prodotto non trovato', data.message);
                return;
            }

            // Se data è un array di prodotti
            if (Array.isArray(data) && data.length > 0) {
                const product = data[0]; 
                const descr = product.description;
                const price = product.sellPrice;
                const prodid = product.product_ID;
                const vatrep = product.vatRep;
                const note = product.note;
                const qta = product.quantity;
                showSearchResults(data); 
            } else {
                showMessage('warning', 'Prodotto non trovato', 'Nessun prodotto corrisponde alla ricerca.');
            }
        },
        error: function (error) {
            console.error('Errore durante la ricerca del prodotto:', error);
            showMessage('error', 'Errore', 'Impossibile completare la ricerca del prodotto.');
        }
    });
}


function showSearchResults(products) {
    const $searchResults = $('#searchResults');
    $searchResults.empty().show(); // Clear and show the results container

    products.forEach(function (product) {
        var Product_ID = product.product_ID;
        const Description = product.description;
        const SellPrice = product.sellPrice;
        const Codice = product.note;
        const qta = product.quantity;
        if (!Product_ID) {
            console.error("ID prodotto non trovato:", product);
            return;
        }

        // Crea un elemento con due righe: la prima per la descrizione, la seconda per codice e prezzo
        const item = $(`
            <a href="#" class="dropdown-item">
                <div style="font-weight: bold;">${Description}</div>
                <div style="font-size: 0.9em; color: gray;">${Codice} - € ${SellPrice.toFixed(2)}</div>
            </a>
        `);

        item.on('click', function (event) {
            event.preventDefault(); // Prevent default anchor behavior
            if (qta < 0) {
                //Product_ID = Product_ID + "- 1";
                Product_ID = `${Product_ID}-${Date.now()}`; 
            }
            addProductToCart(Product_ID, Description, SellPrice, product.vatRep); // Add product to cart
            $searchResults.hide(); // Hide the results container
            $('#barcodeInput').val(''); // Clear the search input
        });

        $searchResults.append(item);
    });

    // Hide results if clicking outside the search results or input
    $(document).on('click', function (e) {
        if (!$(e.target).closest('#searchResults, #barcodeInput').length) {
            $searchResults.hide();
        }
    });
}

// Funzione per effettuare una chiamata AJAX combinata
function makeAjaxCallCombine(url, param, saleData) {
    return new Promise(function (resolve, reject) {
        var combinedData = {
            cmd: param,
            saleData: saleData
        };
        var settings = {
            async: true,
            rejectUnauthorized: false,
            crossDomain: true,
            url: url + "/api/Proxy/forward",
            method: "POST",
            timeout: 5000,
            headers: {
                "Content-Type": "application/json",
                "Accept": "*/*",
                'Access-Control-Allow-Origin': '*'
            },
            data: JSON.stringify(combinedData),
            success: function (response) {
                resolve(response);
            },
            error: function (xhr, status, error) {
                console.error("Errore durante la chiamata AJAX:", error);
                reject(new Error("Errore durante la chiamata AJAX: " + error));
            }
        };

        $.ajax(settings)
            .done(function (data) {
                resolve(data);
            })
            .fail(function (jqXHR, textStatus, errorThrown) {
                reject("Errore: " + textStatus + ". " + jqXHR.responseText);
            });
    });
}


function processOnlineSale(paymode) {
    return new Promise((resolve, reject) => {
        console.log("App è online pagamento ", paymode);

        document.getElementById("SellDate").value = getCurrentDate(1);
        document.getElementById("FiscalDate").value = getCurrentDate(1);

        const totalAmountElement = document.getElementById('total-amount');
        if (!totalAmountElement) {
            console.error("Elemento 'total-amount' non trovato nel DOM.");
            removeLoadingOverlay();
            showMessage('error', 'Errore', 'Elemento totale non trovato.');
            return reject(); // Usa reject per segnalare un errore
        }

        const totalAmountText = totalAmountElement.textContent.replace('€', '').trim();
        const totalAmount = parseFloat(totalAmountText);

        if (isNaN(totalAmount)) {
            console.error('Il totale non è un numero valido:', totalAmountText);
            removeLoadingOverlay();
            showMessage('error', 'Errore', 'Totale non valido.');
            return reject(); // Usa reject per segnalare un errore
        }

        var saleHeader = {
            Code: generateUniqueCode(),
            SaleDate: $("#SellDate").val(),
            TotalSalePrice: parseFloat($('#total-amount').text().replace(',', '.')).toFixed(2),
            DiscountPercentage: ($("#DiscountPercentage").val() || "0").toString(),
            CreationDate: $("#CreationDate").val() || getCurrentDate(1),
            Pos_ID: "2",
            FiscalDate: $("#FiscalDate").val(),
            TotalPriceNoDiscount: parseFloat($('#total-amount').text().replace(',', '.')).toFixed(2),
            isblue: "false",
            UserId: "e17ec975-2659-4d11-bf15-45eaebe21b17"
        };

        var raws = [];
        var descr = [];
        var rawsQty = [];
        var rawsPrice = [];
        var rawsVat = [];
        var rawsDiscount = [];

        // Processa gli articoli nel carrello
        document.querySelectorAll('.cart-item').forEach(function (item) {
            var prodid = item.getAttribute('data-id');
            if (prodid.includes('-')) {
                prodid = prodid.split('-')[0]; // Estrai solo l'ID base
            }

            const descrElement = item.querySelector('.descr');
            const qtyElement = item.querySelector('.quantity');
            const priceElement = item.querySelector('.price');
            const vatElement = item.querySelector('.raws-vat'); 
            const discountElement = item.querySelector('.discount');

            if (!descrElement || !qtyElement || !priceElement || !vatElement || !discountElement) {
                console.error(`Errore: uno o più elementi mancanti per il prodotto con ID: ${prodid}`);
                console.log({
                    descrElement,
                    qtyElement,
                    priceElement,
                    vatElement,
                    discountElement
                });
                return; // Termina il loop se manca qualche elemento
            }

            const price = parseFloat(priceElement.value).toFixed(2);
            const qty = parseInt(qtyElement.value, 10).toString();
            const discount = parseFloat(discountElement.value).toString() || "0";
            const vat = vatElement.value;

            descr.push(descrElement.textContent.trim());
            raws.push(prodid);
            rawsQty.push(qty);
            rawsPrice.push(price);
            rawsVat.push(vat);
            rawsDiscount.push(discount);
        });

        var dataToSend = {
            SaleHeader: saleHeader,
            Raws: raws,
            Descr: descr,
            RawsQty: rawsQty,
            RawsPrice: rawsPrice,
            RawsVat: rawsVat,
            RawsDiscount: rawsDiscount
        };

        console.log("Dati da inviare:", JSON.stringify(dataToSend));

        // Invio della richiesta AJAX
        $.ajax({
            url: "/sale/Create/",
            type: 'POST',
            contentType: "application/json; charset=utf-8",
            data: JSON.stringify(dataToSend),
            success: function (data) {
                if (data.success) {
                    buildCommands(dataToSend, paymode);
                    executeCommands(dataToSend, paymode);
                    handleSuccessfulSale(dataToSend, paymode);
                    resolve(); // Risolve la Promise quando la vendita è completata
                } else {
                    removeLoadingOverlay();
                    showMessage('error', 'Errore', data.message || 'Errore durante la vendita.');
                    reject(); // Segnala un errore
                }
            },
            error: function (xhr) {
                showMessage('error', 'Errore', 'Errore durante il processo di vendita.');
                reject(new Error('Errore nella comunicazione con il server.')); // Segnala un errore
            }
        });
    });
}


function processOnlineSaleOld(paymode) {
    console.log("App è online");
    document.getElementById("SellDate").value = getCurrentDate(1);
    document.getElementById("FiscalDate").value = getCurrentDate(1);

    const totalAmountElement = document.getElementById('total-amount');
    if (!totalAmountElement) {
        console.error("Elemento 'total-amount' non trovato nel DOM.");
        removeLoadingOverlay();
        showMessage('error', 'Errore', 'Elemento totale non trovato.');
        return;
    }

    const totalAmountText = totalAmountElement.textContent.replace('€', '').trim();
    const totalAmount = parseFloat(totalAmountText);

    if (isNaN(totalAmount)) {
        console.error('Il totale non è un numero valido:', totalAmountText);
        removeLoadingOverlay();
        showMessage('error', 'Errore', 'Totale non valido.');
        return;
    }

    var saleHeader = {
        Code: generateUniqueCode(),
        SaleDate: $("#SellDate").val(),
        TotalSalePrice: parseFloat($('#total-amount').text().replace(',', '.')).toFixed(2),
        DiscountPercentage: ($("#DiscountPercentage").val() || "0").toString(),
        CreationDate: $("#CreationDate").val() || getCurrentDate(1),
        Pos_ID: "2",
        FiscalDate: $("#FiscalDate").val(),
        TotalPriceNoDiscount: parseFloat($('#total-amount').text().replace(',', '.')).toFixed(2),
        isblue: "false",
        UserId: "e17ec975-2659-4d11-bf15-45eaebe21b17"
    };

    var raws = [];
    var descr = [];
    var rawsQty = [];
    var rawsPrice = [];
    var rawsVat = [];
    var rawsDiscount = [];

    //document.querySelectorAll('.cart-item').forEach(function (item) {
    //    var prodid = item.getAttribute('data-id');

    //    // Verifica se l'ID contiene un suffisso
    //    if (prodid.includes('-')) {
    //        prodid = prodid.split('-')[0];  // Estrai solo l'ID base
    //    }

    //    // Converti l'ID prodotto in un numero intero
    //    var prodidValue = parseInt(prodid, 10);  // Dichiara e assegna la variabile qui
    //    if (isNaN(prodidValue)) {
    //        console.error("Errore: prodidValue non è un numero valido per il prodotto:", prodid);
    //        return;  // Esci se l'ID prodotto non è valido
    //    }

    //    // Recupero degli altri elementi
    //    const descrElement = item.querySelector('.descr');
    //    const qtyElement = item.querySelector('.quantity');
    //    const priceElement = item.querySelector('.price');
    //    const vatElement = item.querySelector(`input[name="raws-vat[]"][data-id="${prodid}"]`);
    //    const discountElement = item.querySelector('.discount');

    //    // Controlla se tutti gli elementi sono presenti
    //    if (!descrElement || !qtyElement || !priceElement || !vatElement || !discountElement) {
    //        console.error("Uno o più elementi (descrizione, quantità, prezzo, IVA, sconto) non trovati per il prodotto con ID:", prodid);
    //        return;
    //    }

    //    // Continua a elaborare il carrello
    //    const price = parseFloat(priceElement.value).toFixed(2);
    //    const qty = parseInt(qtyElement.value, 10);
    //    const discount = parseFloat(discountElement.value) || 0;
    //    const vat = vatElement.value;

    //    descr.push(descrElement.textContent.trim());
    //    raws.push(prodidValue);  // Usa prodidValue qui
    //    rawsQty.push(qty);
    //    rawsPrice.push(price);
    //    rawsVat.push(vat);
    //    rawsDiscount.push(discount);

    //    console.log("Prodotto elaborato:", {
    //        descr: descrElement.textContent.trim(),
    //        qty,
    //        price,
    //        discount,
    //        vat
    //    });
    //});

    document.querySelectorAll('.cart-item').forEach(function (item) {
        var prodid = item.getAttribute('data-id');

        if (prodid.includes('-')) {
            prodid = prodid.split('-')[0];  // Estrai solo l'ID base
        }

        // Recupero degli altri elementi
        const descrElement = item.querySelector('.descr');
        const qtyElement = item.querySelector('.quantity');
        const priceElement = item.querySelector('.price');
        const vatElement = item.querySelector(`input[name="raws-vat[]"][data-id="${prodid}"]`);
        const discountElement = item.querySelector('.discount');

        // Log dei dettagli mancanti
        if (!descrElement) console.error("Descrizione non trovata per il prodotto con ID:", prodid);
        if (!qtyElement) console.error("Quantità non trovata per il prodotto con ID:", prodid);
        if (!priceElement) console.error("Prezzo non trovato per il prodotto con ID:", prodid);
        if (!vatElement) console.error("IVA non trovata per il prodotto con ID:", prodid);
        if (!discountElement) console.error("Sconto non trovato per il prodotto con ID:", prodid);

        if (!descrElement || !qtyElement || !priceElement || !vatElement || !discountElement) {
            console.error("Errore: uno o più elementi (descrizione, quantità, prezzo, IVA, sconto) non trovati.");
            return;
        }

        // Se tutti gli elementi sono presenti, continua con la logica
        const price = parseFloat(priceElement.value).toFixed(2);
        const qty = parseInt(qtyElement.value, 10);
        const discount = parseFloat(discountElement.value) || 0;
        const vat = vatElement.value;

        descr.push(descrElement.textContent.trim());
        raws.push(prodid);  // Aggiungi il prodotto alla lista dei dati da inviare
        rawsQty.push(qty);
        rawsPrice.push(price);
        rawsVat.push(vat);
        rawsDiscount.push(discount);
    });



    var dataToSend = {
        SaleHeader: saleHeader,
        Raws: raws,
        Descr: descr,
        RawsQty: rawsQty,
        RawsPrice: rawsPrice,
        RawsVat: rawsVat,
        RawsDiscount: rawsDiscount
    };

    console.log("Dati da inviare:", JSON.stringify(dataToSend));

    if (raws.length === 0 || descr.length === 0 || rawsQty.length === 0 || rawsPrice.length === 0 || rawsVat.length === 0) {
        console.error("Errore: uno o più campi sono vuoti. Dati non validi per l'invio.");
        removeLoadingOverlay();
        showMessage('error', 'Errore', 'Carrello vuoto o dati non validi.');
        return;
    }

    return new Promise((resolve, reject) => {
        $.ajax({
            url: "/sale/Create/",
            type: 'POST',
            contentType: "application/json; charset=utf-8",
            data: JSON.stringify(dataToSend),
            success: function (data) {
                if (data.success) {
                    buildCommands(dataToSend, paymode);
                    executeCommands(dataToSend, paymode);
                    handleSuccessfulSale(dataToSend, paymode);
                } else {
                    removeLoadingOverlay();
                    showMessage('error', 'Errore', data.message || 'Errore durante la vendita.');
                }
            },
            error: function (xhr) {
                showMessage('error', 'Errore', 'Errore durante il processo di vendita.');
                reject(new Error('Errore nella comunicazione con il server.'));
            }
        });
    });

}


// Funzione per inviare i comandi al proxy locale
async function send2localproxy(data) {
    console.log('Invio al proxy locale, index: ' + index);
    restCmd = "";
    var ix;

    for (ix = 0; ix < commands.length; ix++) {
        restCmd += commands[ix] + "\r\n";
        console.log("Comando elaborato: " + ix + " -> " + commands[ix]);
    }
    restCmd += "wecfine\r\n";

    var saleData = $("#Sale").serialize();
    if (data && data.id) {
        saleData += '&saleid=' + data.id;
    }

    console.log('Comandi inviati: ' + restCmd + ' | Dati vendita: ' + saleData);

    makeAjaxCallCombine(cashPoints, restCmd, saleData)
        .then(function (response) {
            handleSuccess(response);
            console.log('Risposta ricevuta -> ' + restCmd + ' ' + response);
            restCmd = "";
            cmd.length = 0;
        })
        .catch(function (error) {
            console.error('Errore durante la chiamata al proxy:', error);
            restCmd = "";
            cmd.length = 0;

            $(".success").show();
            $(".failureText").show();
            if (error && error.message && error.message.includes('net::ERR_CONNECTION_REFUSED')) {
                console.log('Errore di connessione rifiutata');
                $(".errorMessage").html('Errore di connessione al registratore di cassa: Controllare CashProxy');
            } else {
                $(".errorMessage").html('Attenzione ERRORE comunicazione con registratore di cassa!!!!');
            }

            document.getElementById('overlay').style.display = 'none';
            $('#pleaseWaitDiv').modal('hide');
            setTimeout(function () {
                $(".success").hide();
                $(".failureText").hide();
            }, 7000);
        });
    

}
